/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.task.ProcessResultsApp;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;

public class ProcessResultsBean
implements DataBean,
TaskActionListener {
    private transient ItemDescriptor[] m_idResultsTable;
    private transient ColumnDescriptor[] m_cdResultsTableStructure;
    private int[] m_iResultsTableSelection;
    private String m_sErrorMsg;
    private static final String TRACE_MASKT = "XFRMPRBT";
    private static final String TRACE_MASKF = "XFRMPRBF";
    private static final String TRACE_MASKD = "XFRMPRBD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "ProcResBean");
    private CompletionReport[] reports;
    private LocalizableText[] names;
    private ProcessResultsApp app;
    private UserTaskManager utm;
    private boolean allowCancel;
    private static final String ERROR_MSG = "ErrorMsg";
    private static final String RESULTS_TABLE = "ResultsTable";
    private static final String CANCEL_BUTTON = "CancelButton";
    public static final String OK_BUTTON = "OKButton";

    public ProcessResultsBean(CompletionReport[] reports, LocalizableText[] names, ProcessResultsApp app, boolean allowCancel) {
        Trace.trace(TRACE_MASKF, "<> ProcessResultsBean");
        this.reports = reports;
        this.names = names;
        this.app = app;
        this.allowCancel = allowCancel;
    }

    public void setUTM(UserTaskManager utm) {
        this.utm = utm;
    }

    public ProcessResultsApp getApp() {
        return this.app;
    }

    public ColumnDescriptor[] getResultsTableRowStructure() {
        return this.m_cdResultsTableStructure;
    }

    public int getResultsTableRowStatus() {
        return 3;
    }

    public int getResultsTableRowCount() {
        return this.reports.length;
    }

    public ItemDescriptor[] getResultsTableRowAt(int index) {
        ItemDescriptor[] id = new ItemDescriptor[]{new ItemDescriptor("Report_" + index, this.names[index].toString())};
        return id;
    }

    public void setResultsTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
    }

    public int[] getResultsTableSelection() {
        return this.m_iResultsTableSelection;
    }

    public void setResultsTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iResultsTableSelection = selected;
        if (selected != null && selected.length > 0) {
            LocalizableText error = this.reports[selected[0]].getText();
            if (error == null) {
                error = new LocalizableText("com.ibm.hwmca.fw.task.res.ProcessResultsRes", "ResultsPanel.unknownerror");
            }
            this.setErrorMsg(this.removeHTML(error.toString()));
            this.utm.refreshElement(ERROR_MSG);
        }
    }

    private String removeHTML(String inString) {
        String outString = inString;
        StringUtils stringUtils = new StringUtils();
        outString = StringUtils.replace(outString, "<BR>", "\n");
        return outString;
    }

    public String getErrorMsg() {
        return this.m_sErrorMsg;
    }

    public void setErrorMsg(String s) {
        this.m_sErrorMsg = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void load() {
        this.m_idResultsTable = new ItemDescriptor[0];
        this.m_iResultsTableSelection = new int[0];
        this.m_sErrorMsg = "";
    }

    public void prepare() {
        if (!this.allowCancel) {
            this.utm.setShown(CANCEL_BUTTON, false);
        }
    }

    public void actionPerformed(TaskActionEvent e) {
        Trace.trace(TRACE_MASKT, "-> ResultsBean.actionPerformed()");
        UserTaskManager srcUTM = (UserTaskManager)e.getSource();
        srcUTM.storeAllElements();
        ProcessResultsBean srcBean = (ProcessResultsBean)srcUTM.getDataObjects()[0];
        String command = e.getActionCommand();
        ProcessResultsApp app = srcBean.getApp();
        Trace.trace(TRACE_MASKF, "command: " + command);
        app.doButton(command);
        srcUTM.dispose();
        Trace.trace(TRACE_MASKT, "<- ResultsBean.actionPerformed()");
    }
}

